#ifndef __Threading__
#define __Threading__

/**
 * @file Threading.h
 * @brief Single include for the threading package
 *
 * @date 14/08/2005
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Threading.h,v 1.3 2007/02/08 21:06:44 paul Exp $
 */
/**
 * @namespace Exponent::Threading
 * @brief Threading namespace
 *
 * Thread handling classes
 */

#include "CCriticalSection.hpp"
#include "CCriticalSectionScope.hpp"
#include "IThread.hpp"
#include "IThreadListener.hpp"
#include "CThreadManager.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::Threading;
#endif

#endif	// End of Threading.h